import React, { useEffect, useRef } from 'react';

interface AudioManagerProps {
  lastEvent?: 'done' | 'failed' | 'process_complete';
}

export const AudioManager: React.FC<AudioManagerProps> = ({ lastEvent }) => {
  const bellRef = useRef<HTMLAudioElement | null>(null);
  const alarmRef = useRef<HTMLAudioElement | null>(null);
  const fanfareRef = useRef<HTMLAudioElement | null>(null);

  useEffect(() => {
    if (!lastEvent) return;

    // These would be real audio files in a production app
    console.log(`[Audio] Playing sound for: ${lastEvent}`);
    
    switch (lastEvent) {
      case 'done':
        bellRef.current?.play().catch(() => {});
        break;
      case 'failed':
        alarmRef.current?.play().catch(() => {});
        break;
      case 'process_complete':
        fanfareRef.current?.play().catch(() => {});
        break;
    }
  }, [lastEvent]);

  return (
    <div className="hidden">
      <audio ref={bellRef} src="/sounds/bell.mp3" />
      <audio ref={alarmRef} src="/sounds/alarm.mp3" />
      <audio ref={fanfareRef} src="/sounds/fanfare.mp3" />
    </div>
  );
};
