import React from 'react';
import { Activity, ShieldAlert, LayoutDashboard } from 'lucide-react';

interface ProcessSidebarProps {
  processes: Array<{
    id: string;
    name: string;
    status: 'active' | 'failed' | 'idle';
  }>;
  selectedId: string;
  onSelect: (id: string) => void;
}

export const ProcessSidebar: React.FC<ProcessSidebarProps> = ({ processes, selectedId, onSelect }) => {
  return (
    <div className="w-80 border-r border-gold-200/10 flex flex-col h-full bg-galaxy-950/80 backdrop-blur-xl relative z-20">
      <div className="p-6">
        <div className="flex items-center gap-3 text-gold-200 mb-10 pl-2">
          <LayoutDashboard className="w-6 h-6" />
          <h1 className="text-lg font-heading font-bold tracking-widest text-slate-100 uppercase">
            Mission Control
          </h1>
        </div>

        <nav className="space-y-2">
          {processes.map((p) => (
            <button
              key={p.id}
              onClick={() => onSelect(p.id)}
              className={`w-full text-left p-4 rounded-xl flex items-center justify-between transition-all group border ${
                selectedId === p.id 
                  ? 'bg-gold-glow border-gold-200/40' 
                  : 'hover:bg-galaxy-900/50 border-transparent hover:border-galaxy-800'
              }`}
            >
              <div className="flex flex-col gap-1">
                <span className={`text-sm font-medium transition-colors ${selectedId === p.id ? 'text-gold-100' : 'text-slate-400 group-hover:text-slate-200'}`}>
                  {p.name}
                </span>
                <span className="text-[10px] text-slate-600 uppercase font-bold tracking-tighter">
                  {p.id}
                </span>
              </div>
              {p.status === 'active' ? (
                <Activity className="w-4 h-4 text-emerald-500 animate-pulse" />
              ) : p.status === 'failed' ? (
                <ShieldAlert className="w-4 h-4 text-rose-500" />
              ) : null}
            </button>
          ))}
        </nav>
      </div>

      <div className="mt-auto p-6 border-t border-gold-200/5 bg-galaxy-900/20">
        <div className="p-4 bg-galaxy-950/50 rounded-xl border border-galaxy-800">
          <p className="text-[10px] text-slate-500 uppercase font-black mb-3 tracking-wider">System Status</p>
          <div className="flex items-center justify-between mb-2">
            <span className="text-xs text-slate-300">Audio Feedback</span>
            <div className="w-8 h-4 bg-emerald-500/20 border border-emerald-500/50 rounded-full relative">
              <div className="absolute right-0.5 top-0.5 w-3 h-3 bg-emerald-500 rounded-full shadow-[0_0_5px_#10B981]" />
            </div>
          </div>
          <div className="flex items-center justify-between">
            <span className="text-xs text-slate-300">Hyperspace Link</span>
            <span className="text-[10px] text-gold-200 font-mono">ONLINE</span>
          </div>
        </div>
      </div>
    </div>
  );
};