// ============ Legacy Story Runner Types ============
export type StoryStatus = 'pending' | 'running' | 'done' | 'failed';

export interface Story {
  id: string;
  title: string;
  status: StoryStatus;
  duration?: number;
  phase?: string;
  startedAt?: string;
}

export interface Run {
  id: string;
  overallStatus: 'running' | 'failed' | 'done' | 'stalled';
  lastHeartbeat: string;
  stories: Story[];
}

export interface Failure {
  runId: string;
  storyId: string;
  reason: string;
  logs: string;
}

export interface Process {
  id: string;
  name: string;
  status: 'active' | 'failed' | 'idle';
  currentRun?: Run;
  lastFailure?: Failure;
}

export interface DashboardData {
  processes: Process[];
}

// ============ Terminal Monitor Types ============
export type TerminalType = 'claude' | 'gemini' | 'codex' | 'powershell' | 'cmd' | 'vscode' | 'node' | 'other';
export type TerminalStatus = 'active' | 'idle' | 'busy' | 'working';

export interface ChildProcess {
  pid: number;
  name: string;
  cmdline: string;
  cpu_percent: number;
  memory_mb: number;
}

export interface Terminal {
  pid: number;
  ppid: number;
  type: TerminalType;
  name: string;
  status: TerminalStatus;
  cwd: string;
  cmdline: string;
  cpu_percent: number;
  memory_mb: number;
  started_at: string;
  uptime_minutes: number;
  parent_terminal: string | null;
  children: ChildProcess[];
  // Activity tracking fields
  active_children: number;
  io_read_bytes: number;
  io_write_bytes: number;
}

export interface SystemStats {
  cpu_percent: number;
  memory_total_gb: number;
  memory_used_gb: number;
  memory_percent: number;
  now_epoch?: number;
}

export interface TerminalData {
  terminals: Terminal[];
  systemStats: SystemStats | null;
  selectedPid: number | null;
}
